//
//  TTTGameView.h
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
@class TTTBoard;
@class TTTGameSessionViewController;

@interface TTTGameView : NSObject{
    @private TTTBoard *gameBoard;
    @private UITextField *statusTextField;
    @private UITextField *sessionScoresTextField;
}

    - (void) setGameViewComponents :(TTTBoard *) theBoard :(UITextField *) theStatusTextField
                                   :(UITextField *) theSessionScoresTextField;
    - (void) setGameStatus :(NSString *) message;

    - (void) showScores :(NSString *) player1Name :(int) player1Score
                        :(NSString *) player2Name :(int) player2Score;

    - (void) placeSymbol :(int) x :(int) y;
    - (void) redraw;
    - (void) promptToProceed :(TTTGameSessionViewController *) DelegateObject;

@end
